/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.engine;

import java.util.ArrayList;
import org.h14199.command.CommandInterface;
import org.h14199.engine.SessionInterface;
import org.h14199.result.ResultInterface;
import org.h14199.util.Utils;
import org.h14199.value.Value;

abstract class SessionWithState
implements SessionInterface {
    protected ArrayList<String> sessionState;
    protected boolean sessionStateChanged;
    private boolean sessionStateUpdating;

    SessionWithState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateSessionState() {
        if (this.sessionState != null && !this.sessionState.isEmpty()) {
            this.sessionStateUpdating = true;
            try {
                for (String string : this.sessionState) {
                    CommandInterface commandInterface = this.prepareCommand(string, Integer.MAX_VALUE);
                    commandInterface.executeUpdate(false);
                }
            }
            finally {
                this.sessionStateUpdating = false;
                this.sessionStateChanged = false;
            }
        }
    }

    public void readSessionState() {
        if (!this.sessionStateChanged || this.sessionStateUpdating) {
            return;
        }
        this.sessionStateChanged = false;
        this.sessionState = Utils.newSmallArrayList();
        CommandInterface commandInterface = this.prepareCommand("SELECT * FROM INFORMATION_SCHEMA.SESSION_STATE", Integer.MAX_VALUE);
        ResultInterface resultInterface = commandInterface.executeQuery(0, false);
        while (resultInterface.next()) {
            Value[] valueArray = resultInterface.currentRow();
            this.sessionState.add(valueArray[1].getString());
        }
    }
}

